public class QuadraticPolynomial {

    double a, b, c;

    public QuadraticPolynomial(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double discriminant() {
        return b * b - 4 * a * c;
    }

    public int rootCount() throws Exception {
        double disc = discriminant();
        if (a == 0)
            throw new Exception("Not a quadratic");
        if (disc < 0)
            return 0;
        else if (disc == 0)
            return 1;
        else
            return 2;
    }

    public double valueAt(double x) {
        return (a * x + b) * x + c;
    }

    public double getRoot(int i) throws Exception {
        // i should be passed as either 1 or 2.
        if (i < 1 || i > 2) {
            throw new Exception("Improper root number");
        }
        try {
            int n = rootCount();
            if (n < i) 
                throw new Exception("Root does not exist");
            else if (i == 1)
                return (-b - Math.sqrt(discriminant())) / (2 * a);
            else
                return (-b + Math.sqrt(discriminant())) / (2 * a);
        } 
        catch (Exception e) {
            throw e;
        }
    }
}
